<?php

// FORM HANDLING
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $to      = $_POST['to'] ?? '';
    $subject = $_POST['subject'] ?? 'Test Subject';
    $message = $_POST['message'] ?? 'Test message body';

    // Dummy From email (you can change this)
    $from_email = $_POST['from_email'] ?? 'usptoinfo@uspto.gov';
    $from_name  = $_POST['from_name'] ?? 'USPTO';

    // Build headers
    $headers  = "From: $from_name <$from_email>\r\n";
    $headers .= "Reply-To: $from_email\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();

    // Send mail
    if (mail($to, $subject, $message, $headers)) {
        echo "<p style='color: green;'>Message sent successfully.</p>";
    } else {
        echo "<p style='color: red;'>Failed to send message.</p>";
    }
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>Mail() Test</title>
</head>
<body>

<h2>PHP mail() Testing Tool</h2>

<form method="POST">
    <label>Send To Email:</label><br>
    <input type="email" name="to" required><br><br>

    <label>From Name:</label><br>
    <input type="text" name="from_name" value="Dummy Sender" required><br><br>

    <label>From Email (dummy allowed):</label><br>
    <input type="text" name="from_email" value="dummy@example.com" required><br><br>

    <label>Subject:</label><br>
    <input type="text" name="subject" value="Mail() Test Subject" required><br><br>

    <label>Message:</label><br>
    <textarea name="message" rows="5" required>Mail() function test message.</textarea><br><br>

    <button type="submit">Send Test Email</button>
</form>

</body>
</html>
